<?php

function rptactionlog(){
	global $db;
	global $codepage;
	
	$user=userinfo();
	$gsid=$user['gsid']+0;

	$now=time();
	
	$day=date('j',$now);
	$mon=date('n',$now);
	$year=date('Y',$now);

	global $paytypes;
	global $paymethods;
	global $lang;
	
	//override date stamp
	$ds=explode('-',SGET('date'));
	if (count($ds)==3){
		$day=$ds[2];
		$mon=$ds[1];
		$year=$ds[0];
		$now=mktime(0,0,0,$mon,$day,$year);	
	}
	
	//// Report Header
	
	$query="select * from ".TABLENAME_REPORTS." where reportkey='actionlog' and (gsid=? or gsid=0) ";
	$rs=sql_prep($query,$db,$gsid);
	$myrow=sql_fetch_assoc($rs);
	$reportgroupnames=$myrow['reportgroupnames'];
	authreport($reportgroupnames);
	
?>
<div class="section">
<?
?>
<div class="sectiontitle" style="margin-bottom:0;"><?echo htmlspecialchars($myrow['reportname_'.$lang]);?></div>
<div class="infobox"><?echo htmlspecialchars($myrow['reportdesc_'.$lang]);?></div>
<?	
	////
	
	$key=SGET('key');
	$opairs=SGET('pairs');
	$pairs=explode(';',$opairs);

	$start=mktime(0,0,0,$mon,$day,$year);
	$end=mktime(23,59,59,$mon,$day,$year);
	
	// $prevday=date('Y-n-j',$start-3600);
	// $nextday=date('Y-n-j',$end+3600);

	$params=array($gsid);
	$query="select * from ".TABLENAME_ACTIONLOG." left join ".TABLENAME_USERS." on ".TABLENAME_ACTIONLOG.".userid=".TABLENAME_USERS.".userid where ".TABLENAME_ACTIONLOG.".gsid=? ";

	if ($key!=''||$opairs!='') {
		$query.=" and alogid!=0 and logmessage!='' ";
		if ($key!='') {
			$query.=" and (logmessage like ? or login like ? or rawobj like ? or logname like ?) ";
			array_push($params,"%$key%","%$key%","%$key%","%$key%");
		}
		foreach ($pairs as $pair){
			$parts=explode('=',$pair);
			$k=trim($parts[0]);
			$v=trim($parts[1]);
			if ($k==''||$v=='') continue;
			$query.=" and rawobj like '%\"$k\":\"$v\"%' ";
		
		}

	}  else {
		$query.=" and logmessage!='' and logdate>=? and logdate<=? ";
		array_push($params,$start,$end);
		
		$q="select logdate from ".TABLENAME_ACTIONLOG." where gsid=? and logmessage!='' and logdate<? order by logdate desc limit 1";
		$rs=sql_prep($q,$db,array($gsid,$start));
		if ($myrow=sql_fetch_array($rs)) $prevday=date('Y-n-j',$myrow['logdate']);

		$q="select logdate from ".TABLENAME_ACTIONLOG." where gsid=? and logmessage!='' and logdate>? order by logdate limit 1";
		$rs=sql_prep($q,$db,array($gsid,$end));
		if ($myrow=sql_fetch_array($rs)) $nextday=date('Y-n-j',$myrow['logdate']);
				
	}
	
	$query.=" order by logdate desc,alogid desc ";
	
	$rs=sql_prep($query,$db,$params);
	$count=sql_affected_rows($db,$rs);
	
		
	if ($key!=''||$opairs!=''){
		$perpage=10;
		$page=$_GET['page']+0;
		$maxpage=ceil($count/$perpage)-1;
		if ($maxpage<0) $maxpage=0;
		if ($page<0) $page=0;
		if ($page>$maxpage) $page=$maxpage;
		$start=$page*$perpage;
		
		$query.=" limit $start,$perpage ";
		$rs=sql_prep($query,$db,$params);
		
	}
	
	
?>

<form onsubmit="reloadtab('rptactionlog',null,'rptactionlog&key='+encodeHTML(gid('actionlog_key').value)+'&pairs='+encodeHTML(gid('actionlog_pairs').value),null,null,{persist:true});return false;">
Search: <input autocomplete="off" class="inp" style="width:30%;" id="actionlog_key" placeholder="Keyword in Action" value="<?echo htmlspecialchars($key);?>"> 
	<input autocomplete="off" class="inp" style="width:30%;" id="actionlog_pairs" placeholder="Advanced Pattern" value="<?echo htmlspecialchars($opairs);?>"> <input class="button" type="submit" value="Go">
</form>
<?
	$pager='';
	
	if ($key!=''||$opairs!=''){
		if ($maxpage>1){
			ob_start();
?>
<div class="listpager">
	<a onclick="reloadtab('rptactionlog',null,'rptactionlog&key=<?echo urlencode($key);?>&pairs=<?echo urlencode($opairs);?>&page=<?echo $page-1;?>',null,null,{persist:true});return false;" class="hovlink" href=#><img src="imgs/t.gif" class="img-pageleft">Prev</a>
	&nbsp; &nbsp;
	<a onclick="var pagenum=sprompt('Go to page:',<?echo $page+1;?>);if (pagenum==null||parseInt(pagenum,0)!=pagenum) return false;reloadtab('rptactionlog',null,'rptactionlog&key=<?echo urlencode($key);?>&pairs=<?echo urlencode($opairs);?>&page='+(pagenum-1),null,null,{persist:true});" class="pageskipper"><?echo $page+1;?></a> of <?echo $maxpage+1;?>
	&nbsp; &nbsp;
	<a onclick="reloadtab('rptactionlog',null,'rptactionlog&key=<?echo urlencode($key);?>&pairs=<?echo urlencode($opairs);?>&page=<?echo $page+1;?>',null,null,{persist:true});return false;" class="hovlink" href=#>Next<img src="imgs/t.gif" class="img-pageright"></a>
</div>
<?			$pager=ob_get_clean();
		}
			
	} else {
		ob_start();
?>
	<div style="padding:20px 0;">
	<?if (isset($prevday)){?>
	<a onclick="reloadtab('rptactionlog',null,'rptactionlog&date=<?echo $prevday;?>',null,null,{persist:true});" style="padding:10px;"><img src="imgs/t.gif" class="img-pageleft"></a> 
	<?}?>
	&nbsp; &nbsp; <a class="hovlink" onclick="gid('rptactionlogdate').value='<?echo "$year-$mon-1";?>';pickdate(gid('rptactionlogdate'),{params:'vmode=actionlog'});"><?echo date('M j, Y',$now);?></a><input type="hidden" id="rptactionlogdate" value="<?echo date('Y-n-j',$now);?>" onchange="if (valdate(this)) reloadtab('rptactionlog',null,'rptactionlog&date='+this.value,null,null,{persist:true});">
	&nbsp; &nbsp;
	<?if (isset($nextday)){?>
	<a onclick="reloadtab('rptactionlog',null,'rptactionlog&date=<?echo $nextday;?>',null,null,{persist:true});" style="padding:10px;"><img src="imgs/t.gif" class="img-pageright"></a>
	<?}?>
	</div>
<?
		$pager=ob_get_clean();
		
	makelookup('rptactionlogdate',1);

}

	echo $pager;
?>
<style>
.alogcol1,.alogcol2,.alogcol3,.alogcol4{float:left;overflow:hidden;}
.alogcol1{width:11%;margin-right:1%;}
.alogcol2{width:14%;margin-right:1%;}
.alogcol3{width:33%;margin-right:1%;}
.alogcol4{width:31%;}

</style>

<?if ($count==0){
?>
<div class="infobox">
	No activities on this day
</div>
<?
}
?>

<div class="stable" <?if ($count==0) echo 'style="display:none;";';?>>

<div class="grid">
	<div class="gridheader"><div class="gridrow">
		<div class="alogcol1">Time</div>
		<div class="alogcol2">User</div>
		<div class="alogcol3">Action</div>
		<div class="alogcol4">Extra</div>
		<div class="clear"></div>
	</div></div>

<?
	$idx=0;
	
	while ($myrow=sql_fetch_array($rs)){
		$alogid=$myrow['alogid'];
		$username=htmlspecialchars($myrow['login']);
		if ($username=='') $username='<span style="color:#ee6666;">'.htmlspecialchars($myrow['logname']).'</span>';
		$logdate=$myrow['logdate'];
		$dlogdate=date('H:i:s',$logdate);
		if ($key!=''||$opairs!='') $dlogdate=date('Y-n-j H:i:s',$logdate);
		$logmessage=$myrow['logmessage'];
		$extra='';
		$obj=json_decode($myrow['rawobj'],1);
		foreach ($obj as $k=>$v) $extra.="; $k=".htmlspecialchars($v);
		$extra=trim($extra,'; ');
?>
	<div class="gridrow<?if ($idx%2==1) echo ' even';?>">
		<div class="alogcol1"><?echo $dlogdate;?>&nbsp;</div>
		<div class="alogcol2"><?echo $username;?>&nbsp;</div>
		<div class="alogcol3"><?echo htmlspecialchars($logmessage);?>&nbsp;</div>
		<div class="alogcol4"><?echo $extra;?>&nbsp;</div>
		<div class="clear"></div>
	</div>
<?
		$idx++;
	}//while
?>
</div><!-- grid -->
</div><!-- stable -->

<?
	if ($count>=5||$key!=''||$opairs!='') echo $pager;
?>

</div><!-- section -->


<?
	
}