<?php

function showreportsetting($reportid=null){
	if (!isset($reportid)) $reportid=GETVAL('reportid');
	
	global $db;
	global $userroles;
	global $lang;
	global $deflang;
	global $userrolelocks;
	
	$user=userinfo();
	$gsid=$user['gsid']+0;
	
	if (!$user['groups']['reportsettings']) apperror('access denied');
	
	$query="select * from ".TABLENAME_REPORTS." where (gsid=? or gsid=0) and reportid=?";
	$rs=sql_prep($query,$db,array($gsid,$reportid));
	
	if (!$myrow=sql_fetch_array($rs)) die(_tr('record_removed'));
	
	$reportname=$myrow['reportname_'.$lang];
	$reportgroup=$myrow['reportgroup_'.$lang];
	$reportkey=$myrow['reportkey'];
	$reportfunc=$myrow['reportfunc'];
	$reportdesc=$myrow['reportdesc_'.$lang];
	$reportgroups=explode('|',$myrow['reportgroupnames']);
	$gyrosys=$myrow['gyrosys'];
	$rptgsid=$myrow['gsid'];

	$reportkey=trim(str_replace('/','',$reportkey));
	$pfn="icl/rpt${reportkey}.inc.php";
	
	header('newtitle:'.tabtitle('<img src="imgs/t.gif" class="ico-setting">'.htmlspecialchars($reportname)));
?>
<div class="section">
	<div class="sectiontitle"><?echo htmlspecialchars($reportname);?></div>

	<?if (!file_exists($pfn)&&$reportfunc==''){?>
<div class="warnbox">
	This report has not been implemented with a default handler. Make sure "rpt<?echo $reportkey;?>" is handled.
</div>	
	<?}?>
	
	<div class="col">


	<div class="inputrow">
		<div class="formlabel"><?tr('reportsetting_label_reportname');?>:</div>
		<input class="inpmed" onfocus="document.hotspot=this;" id="reportname_<?echo $reportid;?>" value="<?echo htmlspecialchars($reportname);?>">
	</div>
	<div class="inputrow">
		<div class="formlabel"><?tr('reportsetting_label_reportgroup');?>:</div>
		<input class="inpmed" onfocus="document.hotspot=this;" id="reportgroup_<?echo $reportid;?>" value="<?echo htmlspecialchars($reportgroup);?>">
	</div>
	<div <?if (!$user['groups']['devreports']) echo 'style="display:none;"';?>>
		<div class="inputrow">
			<div class="formlabel"><?tr('reportsetting_label_reportkey');?>:</div>
			<input class="inpmed" id="reportkey_<?echo $reportid;?>" value="<?echo htmlspecialchars($reportkey);?>">
		</div>
		<div class="inputrow">
			<div class="formlabel"><?tr('reportsetting_label_reportfunc');?>:</div>
			<input class="inpmed" id="reportfunc_<?echo $reportid;?>" value="<?echo htmlspecialchars($reportfunc);?>">
		</div>
	</div>
	<div class="inputrow">
		<div class="formlabel"><?tr('reportsetting_label_reportdesc');?>:</div>
		<textarea onfocus="document.hotspot=this;" class="inplong" style="height:60px;" id="reportdesc_<?echo $reportid;?>"><?echo htmlspecialchars($reportdesc);?></textarea>
	</div>


	</div>
	<div class="col">
		<div class="sectionheader">Access Control</div>
		<div class="infobox">
			Users with Any of the following rights can see this report:
		</div>
		
		<?
		$jsroles='';
		
		foreach ($userroles as $role=>$label){
			//if (in_array($role,$userrolelocks)&&!$user['groups'][$role]) continue; //comment out to show, but grey out flags
			if (!in_array($role,$userrolelocks)||$user['groups'][$role]) $jsroles.=",'$role' ";
		?>
		<div style="padding-left:10px;margin-bottom:3px;">
			<input <?if (in_array($role,$userrolelocks)&&!$user['groups'][$role]) echo 'disabled';?> <?if ($rptgsid==0) echo 'disabled';?> type="checkbox" id="reportrole_<?echo $role;?>_<?echo $reportid;?>" <?if (in_array($role,$reportgroups)) echo 'checked';?>> 
			<label for="reportrole_<?echo $role;?>_<?echo $reportid;?>"><?echo $label;?></label>
		</div>
		<?
		}
		
		$jsroles='['.trim($jsroles,',').']';
		?>

	</div>
	<div class="clear"></div>
	

	<div class="inputrow">
		<button <?if ($rptgsid==0) echo 'class="disabled"';?>onclick<?if ($rptgsid==0) echo 'a';?>="updatereportsetting(<?echo $reportid;?>,<?echo $jsroles;?>,'<?emitgskey('updatereportsetting_'.$reportid);?>');"><?tr('button_update');?></button>
	<?if (!$gyrosys&&$user['groups']['devreports']){?>
		&nbsp; &nbsp;
		<button class="warn" onclick="delreportsetting(<?echo $reportid;?>,'<?emitgskey('delreportsetting_'.$reportid);?>');"><?tr('button_delete');?></button>
	<?}?>
	</div>	
	
</div>
<?
}
